/************************************************************************
* \file: trace_dlt_utility.h
*
* \version: $Id: trace_dlt_utility.h,v 1.1 2012/02/24 14:25:53 bkebianyor Exp $
*
* This file declares the Trace back-end for DLT utility functions
*
* \component: Gen2 Trace
*
* \author Mikhail Durnev mikhail_durnev@mentor.com
* \copyright: (c) 2012 ADIT
*
***********************************************************************/

/**
 * Convert unsigned 8bit integer to hexidecimal string representation
 *
 * \parm bin Input integer
 * \parm hex Output string
 *
 * \return Output string (same as hex)
 */
IMPORT U8 *TRACE_bin2hex(U8 bin, U8 *hex);

/**
 * Convert hexidecimal string representation of 8bit integer to integer
 *
 * \parm hex Input string
 *
 * \return Resulting integer (from 0 to 255) 
 *         or -1 if the input string is not a number
 */
IMPORT S32 TRACE_hex2bin(U8 *hex);

